#version 150

#moj_import <fog.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec4 vertexColor;
in vec2 texCoord0;
in vec2 texCoord1;

out vec4 fragColor;

void main() {
    vec4 texture_color = texture(Sampler0, texCoord0);
    vec4 color = vec4(0.0, 0.0, 0.0, 0.0);

    if (texture_color.a < 0.00392156862745098) {
        // If the texture alpha is close to 0, discard the pixel (make it transparent)
        discard;
    } else if (texture_color.a == 0.996078431372549) {
        // Special handling for fully opaque pixels in the texture
        color = vec4(texture_color.rgb, 1.0) * vec4(vertexColor.rgb, 1.0);
    } else {
        // Regular rendering for pixels with alpha between 0 and 1
        color = texture_color * vec4(vertexColor.rgb, 1.0) * vertexColor.a * ColorModulator;
    }

    // Set the alpha value to 1.0 to make the item fully opaque
    fragColor = vec4(color.rgb, 1.0);

    // Apply fog to the final output color
    fragColor = linear_fog(fragColor, vertexDistance, FogStart, FogEnd, FogColor);
}