
// float readChannel(int channel) {
//     return decodeColor(texelFetch(DataSampler, ivec2(4, channel), 0));
// }

float readChannel(int channel) {
    ivec2 texSize = textureSize(DataSampler, 0);

    if (channel < 0 || channel >= texSize.y) {
        return 0.0;
    }

    float value = decodeColor(texelFetch(DataSampler, ivec2(4, channel), 0));

    // Reset to 0 if the decoded value is NaN or infinite
    if (isnan(value) || isinf(value)) {
        return 0.0;
    }

    return value;
}