#version 150

#moj_import <fog.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec4 vertexColor;
in vec2 texCoord0;
in vec2 texCoord1;
in vec4 normal;

in vec3 cornerTex1;
in vec3 cornerTex2;
flat in vec3 cornerTex3;
flat in float tightening;

out vec4 fragColor;

float cutoff = 12.5 * tightening - 0.03;

void main() {
    vec2 cornerUV1 = cornerTex1.xy / cornerTex1.z;
    vec2 cornerUV2 = cornerTex2.xy / cornerTex2.z;
    vec2 cornerUV3 = cornerTex3.xy / cornerTex3.z;
    vec2 minUV = min(cornerUV1, min(cornerUV2, cornerUV3));
    vec2 maxUV = max(cornerUV1, max(cornerUV2, cornerUV3));

    vec2 SamplerSize = textureSize(Sampler0, 0);
    vec2 minUVNew = minUV + cutoff / SamplerSize;
    vec2 maxUVNew = maxUV - cutoff / SamplerSize;

    vec2 t = (texCoord0 - minUVNew) / (maxUVNew - minUVNew);
    if (t.x < 0.0 || 1.0 < t.x || t.y < 0.0 || 1.0 < t.y)
        discard;
    vec2 UV = mix(minUV, maxUV, t);

    vec4 color = texture(Sampler0, UV) * vertexColor * ColorModulator;
    if (color.a < 0.1) {
        discard;
    }
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}
