#version 150

#moj_import <minecraft:fog.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec2 texCoord0;
in vec4 vertexColor;

flat in int isCustomTexture;
flat in int isMarker;
flat in ivec4 iColor;

out vec4 fragColor;

void main() {
    // --- Marker rendering ---
    if (isMarker == 1) {
        fragColor = vec4(iColor.rgb, 255) / 255.0;
        return;
    }

    // --- Custom particle rendering ---
    if (isCustomTexture == 1) {
        vec4 texColor = texture(Sampler0, texCoord0) * vertexColor;
        if (texColor.a < 0.1) discard; // discard fully transparent pixels
        fragColor = texColor;
        return;
    }

    // --- Vanilla particle rendering ---
    vec4 color = texture(Sampler0, texCoord0) * vertexColor * ColorModulator;
    if (color.a < 0.1) discard;
    
    
    fragColor = linear_fog(color, vertexDistance, 0.0, 100.0, vec4(0.0));
}
