//import version of the glsl - keep at 330
#version 330

//required shit for selector to work
uniform sampler2D MainSampler;
uniform sampler2D DataSampler;
uniform sampler2D BlurSampler;
uniform vec2 OutSize;
uniform float GameTime;


//custom shit
#moj_import <shader_selector:marker_settings.glsl>
#moj_import <shader_selector:utils.glsl>
#moj_import <shader_selector:data_reader.glsl>

in vec2 texCoord;
out vec4 fragColor;

uvec2 murmurHash21(uint src) {
    const uint M = 0x5bd1e995u;
    uvec2 h = uvec2(1190494759u, 2147483647u);
    src *= M; src ^= src>>24u; src *= M;
    h *= M; h ^= src;
    h ^= h>>13u; h *= M; h ^= h>>15u;
    return h;
}

vec2 hash21(float src) {
    uvec2 h = murmurHash21(floatBitsToUint(src));
    return uintBitsToFloat(h & 0x007fffffu | 0x3f800000u) - 1.0;
}

// ------------------ Noise functions ------------------
// From David Hoskins
vec3 hash33(vec3 p3) {
    p3 = fract(p3 * vec3(0.1031, 0.1030, 0.0973));
    p3 += dot(p3, p3.yxz + 33.33);
    return fract((p3.xxy + p3.yxx) * p3.zyx) - 0.5;
}

// From Nikita Miropolskiy
float simplex3d(vec3 p) {
    vec3 s = floor(p + dot(p, vec3(1.0 / 3.0)));
    vec3 x = p - s + dot(s, vec3(1.0 / 6.0));
    vec3 e = step(vec3(0), x - x.yzx);
    vec3 i1 = e * (1.0 - e.zxy);
    vec3 i2 = 1.0 - e.zxy * (1.0 - e);
    vec3 x1 = x - i1 + 1.0 / 6.0;
    vec3 x2 = x - i2 + 1.0 / 3.0;
    vec3 x3 = x - 0.5;
    vec4 w = max(0.6 - vec4(dot(x,x), dot(x1,x1), dot(x2,x2), dot(x3,x3)), 0.0);
    w *= w;
    return dot(
        vec4(
            dot(hash33(s), x), 
            dot(hash33(s + i1), x1), 
            dot(hash33(s + i2), x2),  
            dot(hash33(s + 1.0), x3)
        ) * w * w, 
        vec4(52)
    );
}

void main() {

    //default UV
    vec2 UV = texCoord;
    vec4 COLOR = fragColor;
    //getting the center of the screen
    vec2 center = vec2(0.5, 0.5);

	//////////////////////ZOOM
    // zoom factor
    float zoom = readChannel(ZOOM_CHANNEL) * -2; 
    // float zoom_slow = readChannel(ZOOM_SLOW_CHANNEL) * -2;

	// // Center-based UV (0.5,0.5 = screen center)
    vec2 zoomOffset = texCoord - center;

    // // Apply zoom (scale offset down)
    vec2 zoomedUV = UV;
    // vec2 zoomedUV_slow = UV;
    zoomedUV += zoomOffset * zoom;
    // zoomedUV_slow += zoomOffset * zoom_slow;

    ////////////////////////// SHAKE
    //reading the amplitude of a screenshake
    float shake = readChannel(SHAKE_CHANNEL) / 2;

    //offsetting every pixel based on gametime and sin/cos
    vec2 shakeUV = UV;

    shakeUV += hash21(GameTime) * shake;

    UV = (shakeUV + zoomedUV)/2;

    //////////////////////// TILT    Read channel (0–1), remap to -1..1
    float moveR_raw = readChannel(MOVE_RIGHT);
    float moveL_raw = readChannel(MOVE_LEFT);
    float moveR = moveR_raw * 2.0;
    float moveL = moveL_raw * 2.0;

    // Rotation amount in radians
    // Scale up a bit so it’s visible but not extreme
    float tiltAngle = 0.015;
    float tiltAmount = tiltAngle * (moveR - moveL);  // ~±2.8°

    // Center the UVs around screen center
    vec2 centered = UV - center;

    // Apply 2D rotation
    float c = cos(tiltAmount);
    float s = sin(tiltAmount);
    mat2 rot = mat2(c, -s,
                    s,  c);

    UV = rot * centered + center;

    ////////////////////////// VIGNETTE
    //reading the color
    vec3 vignette_color = vec3(10* readChannel(VIGNETTE_RED), 10 * readChannel(VIGNETTE_GREEN), 10 * readChannel(VIGNETTE_BLUE));

    //reading the duration
    float vignette_radius = readChannel(VIGNETTE_RADIUS) * 10;
    float vignette_transparency = readChannel(VIGNETTE_TRANSPARENCY) * 10;

    // --- Compute distance from center ---
    float dist = distance(UV, center);
    
    // --- Apply smooth circular vignette ---
    float vignette = smoothstep(0, 0.5, dist * vignette_radius);

    // --- Apply transparency to vignette ---
    vignette *= vignette_transparency;

    ////////////////////////// HURT VIGNETTE
    //reading the color
    float hurt_channel = readChannel(HURT_CHANNEL);

    vec3 hurt_color;

    if (hurt_channel > 0.0) {
        hurt_color = vec3(1.0, 0.0, 0.0);
    } else {
        hurt_color = vec3(0.0, 0.0, 0.0);
    }

    //reading the duration
    float hurt_radius = hurt_channel * 10;

    // --- Apply smooth circular hurt ---
    float hurt = clamp(1, 1, hurt_radius);
    // smoothstep(0, 0.5, dist * hurt_radius);

    ////////////////////////// BLUR
    // Read blur radius directly from channel
    float blur_radius = readChannel(BLUR_CHANNEL) * 0.02; // tweak scaling

    // Distance from center (optional: for vignette-style scaling)
    float distBlur = distance(UV, center);

    // Base color
    vec3 colBlur = texture(MainSampler, UV).rgb;

    // Accumulate blur samples
    vec3 sumBlur = vec3(0.0);
    int samplesBlur = 100; // number of blur taps

    for (int i = 0; i < samplesBlur; i++) {
        float angleBlur = 6.283185 * float(i) / float(samplesBlur);
        // scale blur radius with distance from center
        vec2 offset = vec2(cos(angleBlur), sin(angleBlur)) * blur_radius * distBlur;

        sumBlur += texture(MainSampler, UV + offset).rgb;
    }

    // Average blurred samples
    vec3 blurColor = sumBlur / float(samplesBlur);    
    
    ////////////////////////// SPEED
    float timer = GameTime * 1200 * 3;
    float speedAlpha = readChannel(SPEED_LINES_CHANNEL);
    vec2 uv = texCoord * OutSize.xy; // absolute pixel coordinates
    float mr = min(OutSize.x, OutSize.y);
    vec2 centered_lines = (uv * 2.0 - OutSize.xy) / mr * 0.5; // range around center

    vec2 p = vec2(0.5) + normalize(centered_lines) * min(length(centered_lines), 0.05);

    // Use TIMER_CHANNEL for animation instead of iTime
    // scale for speed

    vec3 p3 = 13.0 * vec3(p.xy, 0.0) + vec3(0.0, 0.0, timer * 0.025);
    float noise = simplex3d(p3 * 16.0) * 0.5 + 0.5;

    float dist_lines = abs(clamp(length(centered_lines)/12.0, 0.0, 1.0) * noise * 2.0 - 1.0);
    const float e = 0.3;
    float stepped = smoothstep(e - 0.5, e + 0.5, noise * (1.0 - pow(dist_lines, 5.0)));
    float finalOverlay = smoothstep(e - 0.05, e + 0.05, noise * stepped);
    finalOverlay *= speedAlpha;


    // --- Sample the main scene ---
    vec2 safeUV = clamp(UV, vec2(0.0), vec2(1.0));
    vec4 scene = texture(MainSampler, safeUV);
    
    // --- Color stuff ---
    vec3 colorWithVignette = mix(scene.rgb, vignette_color, vignette);
    vec3 colorWithBlur;

    if (hurt_channel > 0.0) {
        vec3 colorHurt = mix(colorWithVignette, hurt_color, hurt);
        colorWithBlur = mix(colorHurt, blurColor, 0.8);
    } else {
        colorWithBlur = mix(colorWithVignette, blurColor, 0.8);
    }
    
    vec3 finalColor = mix(colorWithBlur, vec3(1.0), finalOverlay);

    //if something's wrong
    // if (any(isnan(UV))) {
    // fragColor = texture(MainSampler, texCoord); // fallback
    // return;
    // }

    //output
    fragColor = vec4(finalColor, scene.a);
    // fragColor = texture(MainSampler, texCoord);
    //  fragColor.rgb = mix(fragColor.rgb, COLOR)


    
    ////////////////////// DEBUG PANEL //////////////////////
    // Show channel values in bottom-left 25% of screen
    // if (texCoord.x < 0.5 && texCoord.y < 0.5) {
    //     // Sample values
    //     float valExample    = readChannel(MOVE_LEFT);
    //     float valZoom       = readChannel(MOVE_RIGHT);
    //     float valShake      = readChannel(SHAKE_CHANNEL);
    //     float valVRed       = readChannel(VIGNETTE_RED);
    //     float valVGreen     = readChannel(VIGNETTE_GREEN);
    //     float valVBlue      = readChannel(VIGNETTE_BLUE);
    //     float valVRadius    = readChannel(VIGNETTE_RADIUS);
    //     float valMoveX      = readChannel(MOVE_X_CHANNEL);
    //     float valMoveY      = readChannel(MOVE_Y_CHANNEL);
    //     float valTimer      = readChannel(TIMER_CHANNEL);
    //     float valSpeedLines = readChannel(SPEED_LINES_CHANNEL);

        // Place them in 4x3 grid
        // vec2 uv = texCoord * 2.0; // scale into [0..1] space for debug panel
        // vec2 grid = floor(uv * vec2(4.0, 3.0)); 
        // float idx = grid.x + grid.y * 4.0;

        // float val = 0.0;
        // if      (idx == 0.0)  val = valExample;
        // else if (idx == 1.0)  val = valZoom;
        // else if (idx == 2.0)  val = valShake;
        // else if (idx == 4.0)  val = valVRed;
        // else if (idx == 5.0)  val = valVGreen;
        // else if (idx == 6.0)  val = valVBlue;
        // else if (idx == 7.0)  val = valVRadius;
        // else if (idx == 8.0)  val = valMoveX;
        // else if (idx == 9.0)  val = valMoveY;
        // else if (idx == 10.0) val = valTimer;
        // else if (idx == 11.0) val = valSpeedLines;

        // fragColor = vec4(vec3(val), 1.0); // grayscale brightness = channel value
    // }
}
