
// define distinct values, counting from 1:
#define EXAMPLE_GREYSCALE_CHANNEL 1
#define ZOOM_CHANNEL 2
// #define ZOOM_SLOW_CHANNEL 3
#define SHAKE_CHANNEL 3
#define VIGNETTE_RED 4
#define VIGNETTE_GREEN 5
#define VIGNETTE_BLUE 6
#define VIGNETTE_RADIUS 7
#define MOVE_RIGHT 8
#define MOVE_LEFT 9
#define SPEED_LINES_CHANNEL 10
#define BLUR_CHANNEL 11
#define HURT_CHANNEL 12
#define VIGNETTE_TRANSPARENCY 13

/*
signature:
 ADD_MARKER(channel, green, alpha, op, rate)
*/
// append different marker definitions
#define LIST_MARKERS ADD_MARKER(EXAMPLE_GREYSCALE_CHANNEL, 253, 251, 1, 0.1) ADD_MARKER(ZOOM_CHANNEL, 252, 251, 1, 4) ADD_MARKER(SHAKE_CHANNEL, 254, 251, 0, 1.0) ADD_MARKER(VIGNETTE_RED, 251, 251, 1, 10) ADD_MARKER(VIGNETTE_GREEN, 251, 252, 1, 10) ADD_MARKER(VIGNETTE_BLUE, 251, 253, 1, 10) ADD_MARKER(VIGNETTE_RADIUS, 250, 251, 1, 0.5) ADD_MARKER(MOVE_RIGHT, 249, 251, 1, 3) ADD_MARKER(MOVE_LEFT, 249, 250, 1, 3) ADD_MARKER(SPEED_LINES_CHANNEL, 247, 247, 1, 3) ADD_MARKER(BLUR_CHANNEL, 246, 247, 1, 4) ADD_MARKER(HURT_CHANNEL, 245, 245, 1, 4) ADD_MARKER(VIGNETTE_TRANSPARENCY, 245, 244, 0, 0)

#define MARKER_RED 254

// Screen pixel that the marker ends up on if it uses channel k:
// Mapping follows structure that is like an inverted cantor pairing (but only producing coordinates with an even sum)
#define MARKER_POS(k) (ivec2(2*int(ceil(sqrt(float(k))) - 1.0),0) + (k - int((ceil(sqrt(float(k))) - 1.0)*(ceil(sqrt(float(k))) - 1.0)) - 1)*ivec2(-1, 1))
