#version 150

uniform sampler2D InSampler;
uniform vec4 ColorModulate;
in vec2 texCoord;
out vec4 fragColor;

// --- Noise function ---
float random(vec2 st) {
    return fract(sin(dot(st, vec2(12.9898, 78.233))) * 43758.5453123);
}

// --- Rounded corner mask ---
float roundedMask(vec2 uv, float cornerRadius, float edgeSoftness) {
    uv = abs(uv - 0.5) * 1.95; // center to (0,0)
    vec2 corner = vec2(1.0 - cornerRadius);
    vec2 d = max(uv - corner, 0.0);
    float dist = length(d);
    // Returns 1 inside, 0 outside
    return 1.0 - smoothstep(cornerRadius - edgeSoftness, cornerRadius, dist);
}

void main() {
    vec4 color = texture(InSampler, texCoord);

    // --- Warm tint ---
    vec3 warmTint = vec3(1.0, 0.95, 0.95);
    color.rgb *= warmTint;

    // --- Subtle grayscale mix ---
    float gray = dot(color.rgb, vec3(0.299, 0.587, 0.114));
    color.rgb = mix(vec3(gray), color.rgb, 0.9);

    // --- Vignette ---
    vec2 uv = texCoord - 0.5;
    float vignette = smoothstep(0.9999, 0.5, length(uv));
    color.rgb *= vignette;

    // --- Film grain ---
    float noise = random(texCoord * 100.0) * 0.03;
    color.rgb += noise;

    // --- Rounded corners ---
    float cornerRadius = 0.15;   // adjust roundness (0.0 = none, 0.5 = heavy)
    float edgeSoftness = 0.02;   // feather edge
    float mask = roundedMask(texCoord, cornerRadius, edgeSoftness);

    // Darken outside the mask
    color.rgb *= mask;

    fragColor = color * ColorModulate;
}
