#version 150

#moj_import <minecraft:fog.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec4 vertexColor;
in vec4 directionalLight;
in vec2 texCoord0;

out vec4 fragColor;

void main() {
    vec4 texColor = texture(Sampler0, texCoord0);
    float alpha = texColor.a;

    // Discard nearly invisible pixels
    if (alpha < 0.1) {
        discard;
    }

    // Remove directional lighting from semi-transparent pixels
    vec4 baseColor = texColor * ColorModulator;
    vec4 litColor = texColor * vertexColor * ColorModulator;

    // Select final color
    vec4 finalColor = (alpha < 1.0) ? baseColor : litColor;

    // Fix for alpha == 254 case
    if (int(alpha * 255.0 + 0.5) == 254) {
        finalColor.a *= 255.0 / 254.0;
    }

    fragColor = linear_fog(finalColor, vertexDistance, FogStart, FogEnd, FogColor);
}
