#version 150

#moj_import <light.glsl>
#moj_import <fog.glsl>

in vec3 Position;
in vec4 Color;
in vec2 UV0;
in vec2 UV1;
in ivec2 UV2;
in vec3 Normal;

uniform sampler2D Sampler0;
uniform sampler2D Sampler2;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;
uniform int FogShape;

uniform vec3 Light0_Direction;
uniform vec3 Light1_Direction;

out float vertexDistance;
out vec4 vertexColor;
out vec2 texCoord0;
out vec2 texCoord1;
out vec4 normal;

out vec3 cornerTex1;
out vec3 cornerTex2;
flat out vec3 cornerTex3;
flat out float tightening;

void main() {
    // Output the edges of the UV coordinates to know where the character is (credits to Bálint)
    cornerTex1 = vec3(0);
    cornerTex2 = vec3(0);
    cornerTex3 = vec3(0);
    if (gl_VertexID % 4 == 0) cornerTex1 = vec3(UV0, 1);
    if (gl_VertexID % 4 == 2) cornerTex2 = vec3(UV0, 1);
    if (gl_VertexID % 2 == 1) cornerTex3 = vec3(UV0, 1);

    tightening = all(greaterThan(textureSize(Sampler0,0), vec2(64)))? 0:0.01;
    float offset = tightening;

    if (length(vec3(ProjMat[0][3], ProjMat[1][3], ProjMat[2][3])) < 0.1)
        offset *= 32.0;

    vec3 pos = Position - Normal * offset;

    gl_Position = ProjMat * ModelViewMat * vec4(pos, 1.0);

    vertexDistance = fog_distance(pos, FogShape);
    vertexColor = minecraft_mix_light(Light0_Direction, Light1_Direction, Normal, Color) * texelFetch(Sampler2, UV2 / 16, 0);
    texCoord0 = UV0;
    texCoord1 = UV1;
    normal = ProjMat * ModelViewMat * vec4(Normal, 0.0);

}
