# undo the last action
# @s = player using the undo item
# at @s
# run from main

scoreboard players reset $button_used.undo gm4_pb_data

# set cooldown
execute if score $undo_delay gm4_pb_data matches 1.. run scoreboard players add $undo_repeat gm4_pb_data 1
execute unless score $undo_delay gm4_pb_data matches 1.. run scoreboard players reset $undo_repeat gm4_pb_data
execute unless score $undo_repeat gm4_pb_data matches 1.. run scoreboard players set $undo_delay gm4_pb_data 24
execute if score $undo_repeat gm4_pb_data matches 1..6 run scoreboard players set $undo_delay gm4_pb_data 14
execute if score $undo_repeat gm4_pb_data matches 7.. run scoreboard players set $undo_delay gm4_pb_data 8
function gm4_puzzle_block:technical/inventory/build/buttons/base

# check if player location is sufficiently different from previous saved location
scoreboard players set $set_new_undo_pos gm4_pb_data 1
execute store result score $old_undo_pos_x gm4_pb_data run data get storage gm4_puzzle_block:pusher saved_states[-1].pos[0]
execute store result score $old_undo_pos_z gm4_pb_data run data get storage gm4_puzzle_block:pusher saved_states[-1].pos[2]
execute store result score $new_undo_pos_x gm4_pb_data run data get storage gm4_puzzle_block:pusher undo_state.pos[0]
execute store result score $new_undo_pos_z gm4_pb_data run data get storage gm4_puzzle_block:pusher undo_state.pos[2]
execute if score $old_undo_pos_x gm4_pb_data = $new_undo_pos_x gm4_pb_data if score $old_undo_pos_z gm4_pb_data = $new_undo_pos_z gm4_pb_data run function gm4_puzzle_block:mechanic/undo/check_player_pos
execute if score $set_new_undo_pos gm4_pb_data matches 1 run data modify storage gm4_puzzle_block:pusher undo_state.pos set from storage gm4_puzzle_block:pusher saved_states[-1].pos

# move player back
tag @s add gm4_target
execute summon marker run function gm4_puzzle_block:mechanic/undo/restore/player
tag @s remove gm4_target

# move blocks back
execute as @e[type=marker,tag=gm4_pb_block] if data entity @s data.gm4_puzzle_block.saved_states[-1] at @s run function gm4_puzzle_block:mechanic/undo/restore/block/check_move
execute as @e[type=marker,tag=gm4_pb_block.restore] at @s run function gm4_puzzle_block:mechanic/undo/restore/block/replace

# restore piston blocked states
execute as @e[type=item_display,tag=gm4_pb_piston] if data entity @s item.components."minecraft:custom_data".gm4_puzzle_block.saved_states[-1] at @s run function gm4_puzzle_block:mechanic/undo/restore/piston

# restore magnets
execute as @e[type=slime,tag=gm4_pb_magnet,tag=gm4_pb_magnet.swappable] at @s run function gm4_puzzle_block:mechanic/undo/restore/magnet
execute as @e[type=slime,tag=gm4_pb_magnet,tag=gm4_pb_magnet.rebeam] at @s run function gm4_puzzle_block:mechanic/magnet/recalculate

# restore teleporter states
execute as @e[type=item_display,tag=gm4_pb_teleporter] if data entity @s item.components."minecraft:custom_data".gm4_puzzle_block.saved_states[-1] at @s run function gm4_puzzle_block:mechanic/undo/restore/teleporter

# visuals & sound
execute at @s run playsound puzzle_boxes:effect_undo player @a ^0 ^ ^ 0.35 1

# kill moving blocks
kill @e[type=item_display,tag=gm4_pb_block_display,scores={gm4_pb_moving=1..}]

# remove undo
scoreboard players remove $undo_available gm4_pb_data 1

scoreboard players add $undos_used gm4_pb_puzzle_stats 1
