# reset the current puzzle
# @s = player using the reset item
# at @s
# run from mechanic/reset/using_item

# don't play sounds
scoreboard players set $piston_push gm4_pb_sound_played 1
scoreboard players set $piston_retract gm4_pb_sound_played 1
scoreboard players set $piston_blocked gm4_pb_sound_played 1

# put cooldown on reset until actionbar is removed
scoreboard players set $reset_held gm4_pb_data 6
scoreboard players set @s gm4_pb_view_cd 7

# modify button
data modify storage gm4_puzzle_block:temp reset_cmd set value 115
data modify storage gm4_puzzle_block:temp set.custom_model_data set from storage gm4_puzzle_block:temp reset_cmd
data modify storage gm4_puzzle_block:temp set.slot set value "hotbar.1"
function gm4_puzzle_block:technical/eval_custom_model_data with storage gm4_puzzle_block:temp set

# store undo locations
execute at @p[tag=gm4_pb_pusher,team=player] run function gm4_puzzle_block:mechanic/undo/save_player_pos
function gm4_puzzle_block:mechanic/undo/save_entity_pos

# mark this puzzles pistons, then retract them to allow space
execute as @e[type=item_display,tag=gm4_pb_piston] if score @s gm4_pb_id = $resetting_id gm4_pb_data at @s run function gm4_puzzle_block:mechanic/reset/piston

# move all blocks with this id back to their origin and pusher back to the active respawn point
tag @e[type=marker,tag=gm4_pb_block.current] add gm4_pb_to_reset
execute as @e[type=marker,tag=gm4_pb_to_reset] at @s run function gm4_puzzle_block:mechanic/reset/block_remove
function gm4_puzzle_block:mechanic/reset/stacking/loop_resetting_blocks
execute as @e[type=marker,tag=gm4_pb_to_replace] at @s run function gm4_puzzle_block:mechanic/reset/replace_block
tp @s @e[type=marker,tag=gm4_pb_respawn,limit=1,sort=nearest]

# extend pistons that should start extended
execute as @e[type=item_display,tag=gm4_pb_piston.start_on,tag=gm4_pb_to_reset] at @s run function gm4_puzzle_block:mechanic/piston/push_check

# recalc this puzzles magnets
execute as @e[type=slime,tag=gm4_pb_magnet] at @s if score @s gm4_pb_id = $resetting_id gm4_pb_data at @s run function gm4_puzzle_block:mechanic/magnet/recalculate
# and the swappable magnets (if needed)
execute as @e[type=slime,tag=gm4_pb_magnet.swappable.pull,tag=gm4_pb_magnet.push] at @s if score @s gm4_pb_id = $resetting_id gm4_pb_data run function gm4_puzzle_block:mechanic/magnet/pull/set
execute as @e[type=slime,tag=gm4_pb_magnet.swappable.push,tag=gm4_pb_magnet.pull] at @s if score @s gm4_pb_id = $resetting_id gm4_pb_data run function gm4_puzzle_block:mechanic/magnet/push/set
execute as @e[type=slime,tag=gm4_pb_magnet.swappable] if score @s gm4_pb_id = $resetting_id gm4_pb_data run data remove entity @s ArmorItems[3].components."minecraft:custom_data".gm4_puzzle_block.saved_states

# remove reset tag from blocks and pistons
tag @e[tag=gm4_pb_to_replace] remove gm4_pb_to_replace
tag @e[tag=gm4_pb_to_reset] remove gm4_pb_to_reset

# add undo
scoreboard players add $undo_available gm4_pb_data 1

# vfx
title @s times 2t 1t 7t
title @s title {"text":"A","font":"gm4_pb_transition","color":"#000000"}
execute at @s run playsound ui.loom.take_result player @a ^0 ^ ^ 1 0
execute at @s run playsound block.beehive.shear player @a ^0 ^ ^ 1 0.5

scoreboard players add $resets_used gm4_pb_puzzle_stats 1
