# Gammeode 4 Presents, a Thanathor and Kyrkis Production of The Tale of Joemummas Big Tree Land: World of Puzzles Part 1 (of 1)
# Or Evergrowth: a Gamemode 4 puzzle map
schedule function gm4_puzzle_block:main 1t

# | Dev clock
execute if entity @a[team=dev,gamemode=creative] run function gm4_puzzle_block:dev/clock

# | Processing Before Push
# kill block/item displays and pusher displays that have been tagged to be removed
kill @e[tag=gm4_pb_delete]
tag @e[type=item_display,tag=gm4_pb_pusher_display] add gm4_pb_delete
# process moving blocks and block item_displays
execute as @e[type=item_display,tag=gm4_pb_block_display,scores={gm4_pb_moving=1..}] run function gm4_puzzle_block:technical/block/tick_display
execute as @e[type=marker,tag=gm4_pb_block,scores={gm4_pb_moving=1..}] run function gm4_puzzle_block:technical/block/tick
# magnet beam flicker stop
execute as @e[type=item_display,tag=gm4_pb_magnet.new_beam] run function gm4_puzzle_block:mechanic/magnet/flicker_fix
# piston
execute as @e[type=item_display,tag=gm4_pb_piston,scores={gm4_pb_auto_move=-1..1}] at @s run function gm4_puzzle_block:mechanic/piston/process
execute as @e[type=item_display,tag=gm4_pb_piston,scores={gm4_pb_piston_blocked=1},predicate=gm4_puzzle_block:ambiance/blocked_piston_smoke_chance] at @s run particle large_smoke ^ ^ ^-.4 0.15 0.15 0.15 0.0001 1
# teleporter
execute as @e[type=item_display,tag=gm4_pb_tp_display] run function gm4_puzzle_block:mechanic/teleporter/tp_display
# block movement
execute if entity @e[type=marker,tag=gm4_pb_block.move_check] run function gm4_puzzle_block:block_movement

# | Player Processing / Pushing
execute as @a[gamemode=!spectator] at @s run function gm4_puzzle_block:technical/player/submain
# fix players that died - use @n to only target living players
execute as @n[type=player,scores={gm4_pb_deaths=1..}] run function gm4_puzzle_block:technical/player/respawn

# | Processing After Push
# respawn the beams for magnets that had blocks move around in their beams
execute as @e[type=slime,tag=gm4_pb_magnet,tag=gm4_pb_magnet.rebeam] at @s run function gm4_puzzle_block:mechanic/magnet/recalculate
# reset & undo
execute if score $button_used.reset gm4_pb_data matches 1.. unless entity @e[type=marker,tag=gm4_pb_block,scores={gm4_pb_moving=1..}] as @p[tag=gm4_pb_pusher,team=player] at @s run function gm4_puzzle_block:mechanic/reset/using_item
execute if score $button_used.undo gm4_pb_data matches 1.. as @p[tag=gm4_pb_pusher,team=player] at @s run function gm4_puzzle_block:mechanic/undo/restore/all
execute if score $undo_delay gm4_pb_data matches 1.. run scoreboard players remove $undo_delay gm4_pb_data 1
# buttons
execute as @e[type=item_display,tag=gm4_pb_button,tag=!gm4_pb_goals.locked] at @s run function gm4_puzzle_block:mechanic/button/process
# check if battery should be turned on (plugs)
execute as @e[type=marker,tag=gm4_pb_block.lamp,scores={gm4_pb_moving=0},tag=!gm4_pb_block.lamp.checked] at @s run function gm4_puzzle_block:technical/block/lamp_check
# delete bad item_displays
execute as @e[type=item_display,tag=gm4_pb_block_display.check] at @s run function gm4_puzzle_block:technical/block/check_display

# | Other things
# collectables
execute as @e[type=item_display,tag=gm4_pb_secret,tag=!gm4_pb_secret.disabled] at @s run function gm4_puzzle_block:technical/secret/process
# lore
execute if score $intro_stage gm4_pb_data matches 2.. as @e[type=marker,tag=gm4_pb_lore,tag=!gm4_pb_lore.extended,scores={gm4_pb_moving=0}] at @s positioned ~-3.5 ~1 ~-3.5 if entity @p[tag=gm4_pb_pusher,dx=6,dy=0.1,dz=6,gamemode=!spectator] at @s run function gm4_puzzle_block:technical/lore/check_view/check_extend
execute unless score $intro_stage gm4_pb_data matches 2.. as @e[type=marker,tag=gm4_pb_lore,tag=!gm4_pb_lore.extended,scores={gm4_pb_moving=0}] at @s positioned ~-3.5 ~1 ~-3.5 if entity @p[team=player,dx=6,dy=0.1,dz=6,gamemode=!spectator] at @s run function gm4_puzzle_block:technical/lore/check_view/check_extend
execute as @e[type=marker,tag=gm4_pb_lore,scores={gm4_pb_moving=1..}] run function gm4_puzzle_block:technical/lore/tick
execute as @e[type=marker,tag=gm4_pb_lore.extended,scores={gm4_pb_moving=0}] at @s run function gm4_puzzle_block:technical/lore/check_view/check_contract
# timers
execute if entity @p[team=player,tag=gm4_pb_pusher] run scoreboard players add @e[type=marker,tag=gm4_pb_spectate_loc.active,tag=!gm4_pb_spectate_loc.complete,limit=1] gm4_pb_puzzle_stats 1
execute if score $reset_held gm4_pb_data matches 1.. run scoreboard players remove $reset_held gm4_pb_data 1
scoreboard players reset * gm4_pb_sound_played
execute if entity @p[team=player,tag=gm4_pb_pusher] run scoreboard players add $playtime gm4_pb_puzzle_stats 1
execute if score $playtime gm4_pb_puzzle_stats matches 20.. run function gm4_puzzle_block:technical/stats/clock
# birb
execute if score $intro_stage gm4_pb_data matches 2.. unless score $push_delay gm4_pb_data matches 1.. as @e[type=item_display,tag=gm4_pb_birb,tag=!gm4_pb_birb.flying] at @s as @p[team=player,tag=gm4_pb_pusher,distance=..6,gamemode=!spectator] at @s run function gm4_puzzle_block:technical/birb/check_view
execute unless score $intro_stage gm4_pb_data matches 2.. as @e[type=item_display,tag=gm4_pb_birb,tag=!gm4_pb_birb.flying] at @s as @p[team=player,distance=..6,gamemode=!spectator] at @s run function gm4_puzzle_block:technical/birb/check_view
# player rigs
execute as @e[type=text_display,tag=gm4_pb_player_rig.name] at @s if entity @p[distance=..32,gamemode=!spectator] run function gm4_puzzle_block:player_rig/build
# hints
execute if score $hint_toggling gm4_pb_data matches 4.. as @a[team=player,gamemode=!spectator] run function gm4_puzzle_block:technical/inventory/build/buttons/base
execute if score $hint_toggling gm4_pb_data matches 1.. run scoreboard players remove $hint_toggling gm4_pb_data 1
execute if score $toggle.hints gm4_pb_data matches 1 as @e[type=item_display,tag=gm4_pb_hint] at @s run function gm4_puzzle_block:technical/hints/process
# resource pack sign
execute positioned 952 111 1026 if entity @a[distance=..16] run setblock ~ ~ ~ air
execute positioned 952 111 1026 if entity @a[distance=..16] run setblock ~ ~ ~ warped_wall_sign[facing=west]{front_text:{color:"gray",has_glowing_text:1b,messages:[{"translate":"gm4_pb.resourcepack.sign","fallback":"Resource Pack","color":"#CC0000"},{"translate":"gm4_pb.resourcepack.sign","fallback":"Not Installed","color":"#CC0000"},{"text":""},{"translate":"gm4_pb.resourcepack.sign","fallback":"[ Click Here ]","color":"#4AA0C7","click_event":{"action":"run_command","command":"tellraw @s [{\"text\":\"https://github.com/Gamemode4Dev/Evergrowth_RP/releases/latest/download/Evergrowth_RP.zip\",\"color\":\"#4AA0C7\",\"hover_event\":{\"action\":\"show_text\",\"value\":[{\"text\":\"Click to download Resource Pack\"}]},\"click_event\":{\"action\":\"open_url\",\"url\":\"https://github.com/Gamemode4Dev/Evergrowth_RP/releases/latest/download/Evergrowth_RP.zip\"}}]"}}]},is_waxed:1b}
# box disabling to reduce fps lag
execute as @e[type=marker,tag=gm4_pb_block.box,tag=!gm4_pb_block.disabled,tag=!gm4_pb_block.force_enable,tag=!gm4_pb_block.current,scores={gm4_pb_moving=0}] at @s unless entity @p[tag=gm4_pb_pusher,distance=..16,gamemode=!spectator] run function gm4_puzzle_block:technical/block/disable
execute as @e[type=marker,tag=gm4_pb_block.disabled] at @s if entity @p[tag=gm4_pb_pusher,distance=..12,gamemode=!spectator] run function gm4_puzzle_block:technical/block/enable
# check for command blocks being disabled
execute if score $cmb_enabled gm4_pb_data matches -1 run tellraw @a {"translate":"gm4_pb.cmb_warning","fallback":"Command Blocks are disabled on your server, enable them in server properties or the map will not work!","color":"red"} 
execute if score $cmb_enabled gm4_pb_data matches ..-1 run title @a times 0 5 0
execute if score $cmb_enabled gm4_pb_data matches ..-1 run title @a title {"translate":"gm4_pb.cmb_warning_title","fallback":"Enable Command Blocks!","color":"red","bold":true}
execute if score $cmb_enabled gm4_pb_data matches -1 run scoreboard players set $cmb_enabled gm4_pb_data -2
execute unless score $cmb_enabled gm4_pb_data matches ..-1 run scoreboard players set $cmb_enabled gm4_pb_data -1
