# DEVELOPMENT TOOL
# reset the postition of all puzzle blocks

# don't play sounds
scoreboard players set $piston_push gm4_pb_sound_played 1
scoreboard players set $piston_retract gm4_pb_sound_played 1
scoreboard players set $piston_blocked gm4_pb_sound_played 1

# unblock and retract all pistons
execute if entity @s[scores={gm4_pb_piston_blocked=1}] run data modify entity @s item.components."minecraft:custom_data".gm4_puzzle_block.current_state set value -1
scoreboard players set @e[type=item_display,tag=gm4_pb_piston,scores={gm4_pb_piston_blocked=1}] gm4_pb_piston_blocked 0
execute as @e[type=item_display,tag=gm4_pb_piston.pushed] at @s run function gm4_puzzle_block:mechanic/piston/retract
# reset buttons, plugs, lamps and doors
execute as @e[type=item_display,tag=gm4_pb_goals.locked] at @s run function gm4_puzzle_block:mechanic/button/unlock
scoreboard players reset @e[type=marker,tag=gm4_pb_door] gm4_pb_data
scoreboard players reset @e[type=item_display,tag=gm4_pb_lamp] gm4_pb_data
execute as @e[type=item_display,tag=gm4_pb_lamp.lit] at @s run function gm4_puzzle_block:mechanic/lamp/dim
execute as @e[type=marker,tag=gm4_pb_door.open] at @s run function gm4_puzzle_block:mechanic/door/close
execute as @e[type=marker,tag=gm4_pb_door.all_secrets_1] at @s run function gm4_puzzle_block:mechanic/door/open
execute as @e[type=item_display,tag=gm4_pb_plug] at @s run fill ~ ~-50 ~ ~ ~-50 ~ red_concrete replace redstone_block
execute as @e[type=item_display,tag=gm4_pb_plug] at @s run fill ~ ~-55 ~ ~ ~-55 ~ redstone_block replace red_concrete

# reset block glowing
execute as @e[type=item_display,tag=gm4_pb_block_display.glow] run data modify entity @s Glowing set value 0b
tag @e[type=item_display,tag=gm4_pb_block_display.glow] remove gm4_pb_block_display.glow
tag @e[type=marker,tag=gm4_pb_block.current] remove gm4_pb_block.current

# delete all blocks
execute as @e[type=marker,tag=gm4_pb_block.disabled] at @s run function gm4_puzzle_block:technical/block/enable
execute as @e[type=marker,tag=gm4_pb_block,tag=!gm4_pb_block.pushed] at @s as @e[type=marker,tag=gm4_pb_puzzle_spawner,distance=..0.5] run data modify entity @e[type=item_display,tag=gm4_pb_block_display,limit=1,sort=nearest,distance=..0.5] item set from entity @s data.gm4_puzzle_block.display_data
execute as @e[type=marker,tag=gm4_pb_block,tag=gm4_pb_block.pushed] at @s run function gm4_puzzle_block:dev/delete_block
execute as @e[type=item_display,tag=gm4_pb_block_display] at @s unless entity @e[type=marker,tag=gm4_pb_block,distance=..0.5] run kill @s
# respawn all puzzle blocks
execute as @e[type=marker,tag=gm4_pb_puzzle_spawn_box] at @s align xyz positioned ~0.5 ~0.5 ~0.5 if predicate gm4_puzzle_block:puzzle_blocks/here_push_check summon marker run function gm4_puzzle_block:dev/spawn_box
execute as @e[type=marker,tag=gm4_pb_puzzle_spawn_lamp] at @s align xyz positioned ~0.5 ~0.5 ~0.5 if predicate gm4_puzzle_block:puzzle_blocks/here_push_check summon marker run function gm4_puzzle_block:dev/spawn_lamp
execute as @e[type=marker,tag=gm4_pb_puzzle_spawn_crate] at @s align xyz positioned ~0.5 ~0.5 ~0.5 if predicate gm4_puzzle_block:puzzle_blocks/here_push_check summon marker run function gm4_puzzle_block:dev/spawn_crate
execute as @e[type=marker,tag=gm4_pb_block_moves_on_reset] at @s align xyz positioned ~0.5 ~0.5 ~0.5 run tag @e[type=marker,tag=gm4_pb_block,distance=..0.2] add gm4_pb_block.move_check
# extend pistons that should start extended, then delete their stored data
execute as @e[type=item_display,tag=gm4_pb_piston.start_on] at @s run function gm4_puzzle_block:mechanic/piston/push_check
# set magnets to their start values
kill @e[type=item_display,tag=gm4_pb_magnet.beam]
execute as @e[type=slime,tag=gm4_pb_magnet.swappable.pull] at @s run function gm4_puzzle_block:mechanic/magnet/pull/set
execute as @e[type=slime,tag=gm4_pb_magnet.swappable.push] at @s run function gm4_puzzle_block:mechanic/magnet/push/set
execute as @e[type=slime,tag=gm4_pb_magnet.swappable] run data remove entity @s ArmorItems[3].components."minecraft:custom_data".gm4_puzzle_block.saved_states
execute as @e[type=slime,tag=!gm4_pb_magnet.swappable] at @s run function gm4_puzzle_block:mechanic/magnet/recalculate
tag @e[type=slime,tag=gm4_pb_magnet] remove gm4_pb_magnet.rebeam
# remove any active respawns
tag @e remove gm4_pb_respawn
# delete undo history
function gm4_puzzle_block:mechanic/undo/remove_history

# map specific resets
setblock 1023 114 1180 red_wool
data modify entity @e[type=minecraft:item_display,tag=gm4_pb_decor.factory_1_fake_piston,limit=1,sort=nearest] transformation.translation[2] set value -1.0f
setblock 1014 113 1197 red_mushroom_block[down=false,east=false,north=false,south=false,up=false]
setblock 1014 114 1197 air
fill 1002 104 1154 1002 104 1153 yellow_stained_glass

# respawn hints
function gm4_puzzle_block:dev/respawn_hints
scoreboard players reset $toggle.hints gm4_pb_data
data modify storage gm4_puzzle_block:stats stat.hints_used set value 0

# reset birbs
execute as @e[type=item_display,tag=gm4_pb_birb] at @s run function gm4_puzzle_block:technical/birb/reset

# reset puzzle progress
scoreboard players reset * gm4_pb_completion
scoreboard players set $completion.spring.puzzles gm4_pb_data 0
scoreboard players set $completion.autumn.puzzles gm4_pb_data 0
scoreboard players set $completion.winter.puzzles gm4_pb_data 0
scoreboard players set $completion.summer.puzzles gm4_pb_data 0
scoreboard players reset * gm4_pb_puzzle_stats
scoreboard players set $hints_used gm4_pb_puzzle_stats 0
tag @e[type=marker,tag=gm4_pb_spectator_loc.active] remove gm4_pb_spectator_loc.active
tag @e[type=marker,tag=gm4_pb_spectate_loc.complete] remove gm4_pb_spectate_loc.complete

scoreboard players set $tree_warped gm4_pb_data 2

execute as @a[team=player] run function gm4_puzzle_block:technical/inventory/build/completion/base

# reset collectables
execute as @e[type=item_display,tag=gm4_pb_secret.collected] run function gm4_puzzle_block:technical/secret/respawn
scoreboard players set $collectables gm4_pb_completion 0
scoreboard players set $spring.collectable gm4_pb_completion 0
scoreboard players set $winter.collectable gm4_pb_completion 0
scoreboard players set $autumn.collectable gm4_pb_completion 0
scoreboard players set $summer.collectable gm4_pb_completion 0
scoreboard players set $secrets_counting gm4_pb_data 0

# autumn door
kill @e[type=item_display,tag=gm4_pb_door.autumn]
summon item_display 999.0 110.0 1182.0 {view_range:0.625f,Rotation:[-45F,0F],Tags:["gm4_pb_door.autumn"],transformation:{left_rotation:[0f,0f,0f,1f],right_rotation:[0f,0f,0f,1f],translation:[0f,0f,0f],scale:[4f,4f,4f]},item:{id:"minecraft:gray_dye",count:1,components:{"minecraft:custom_model_data":{floats:[304.0f]}}}}
summon item_display 999.0 110.0 1182.0 {view_range:0.625f,Rotation:[135F,0F],Tags:["gm4_pb_door.autumn"],transformation:{left_rotation:[0f,0f,0f,1f],right_rotation:[0f,0f,0f,1f],translation:[0f,0f,0f],scale:[4f,4f,4f]},item:{id:"minecraft:gray_dye",count:1,components:{"minecraft:custom_model_data":{floats:[304.0f]}}}}
fill 998 108 1182 999 110 1181 air
fill 998 108 1181 998 110 1181 nether_brick_wall
fill 999 108 1182 999 110 1182 nether_brick_wall
fill 998 108 1182 998 110 1182 dark_oak_leaves

# remove title screen if needed
kill @e[tag=gm4_pb_title_screen]

# fix goals
execute as @e[tag=gm4_pb_goals] at @s if block ~ ~-50 ~ red_concrete if block ~ ~-51 ~ command_block{powered:1b} run data modify block ~ ~-51 ~ powered set value 0b
execute as @e[tag=gm4_pb_goals] at @s if block ~ ~-50 ~ red_concrete if block ~ ~-50 ~1 command_block{powered:1b} run data modify block ~ ~-50 ~1 powered set value 0b

# don't optimize first block
execute positioned 962 104 1092 run tag @e[type=marker,tag=gm4_pb_block,limit=1,sort=nearest] add gm4_pb_block.current

# fix goals after 5t
schedule function gm4_puzzle_block:dev/fix_goals 5t

tellraw @s {"translate":"gm4_pb.dev.reset_blocks","fallback":"> reset complete"}
