# ------------------------------------------------------------------------------------------------------------
# Copyright (c) 2024 Gunivers
#
# This file is part of the Bookshelf project (https://github.com/Gunivers/Bookshelf).
#
# This source code is subject to the terms of the Mozilla Public License, v. 2.0.
# If a copy of the MPL was not distributed with this file, You can obtain one at http://mozilla.org/MPL/2.0/.
#
# Conditions:
# - You may use this file in compliance with the MPL v2.0
# - Any modifications must be documented and disclosed under the same license
#
# For more details, refer to the MPL v2.0.
#
# Documentation of the feature: https://bookshelf.docs.gunivers.net/en/latest/modules/math.html#trigonometry
# ------------------------------------------------------------------------------------------------------------

# Normalize angle
scoreboard players operation $math.cos bs.out = $math.cos.x bs.in
execute store result score #math.cos.x bs.data run scoreboard players operation $math.cos bs.out %= 36000 bs.const
execute if score #math.cos.x bs.data matches 9000..27000 run scoreboard players remove $math.cos bs.out 18000
execute if score #math.cos.x bs.data matches 27001.. run scoreboard players remove $math.cos bs.out 36000

# Compute Bhāskara cosine approximation
execute store result score #math.cos.y bs.data run scoreboard players operation $math.cos bs.out *= $math.cos bs.out
scoreboard players operation $math.cos bs.out *= -4 bs.const
scoreboard players add $math.cos bs.out 324000000
scoreboard players add #math.cos.y bs.data 324000000
scoreboard players operation #math.cos.y bs.data /= 1000 bs.const
execute if score #math.cos.x bs.data matches 9000..27000 run scoreboard players operation #math.cos.y bs.data *= -1 bs.const
return run scoreboard players operation $math.cos bs.out /= #math.cos.y bs.data
