import math

# Output file name
output_file = "sin_wave.mcfunction"

# Total number of steps
steps = 20

# Generate sin values scaled to 0–1
def scaled_sin(i, total):
    angle = (i / total) * 2 * math.pi
    value = (math.sin(angle) + 1) / 2  # Normalize from [-1, 1] to [0, 1]
    return round(value, 4)

with open(output_file, 'w') as f:
    # Header
    f.write("scoreboard players add sin darts.main 1\n\n")

    # Write sine wave translation steps
    for i in range(steps):
        sin_val = scaled_sin(i, steps)
        f.write(
            f"execute if score sin darts.main matches {i} run data merge entity @s "
            f"{{transformation:{{translation:[0.0f,0.0f,{sin_val}f]}},interpolation_duration:1,start_interpolation:0}}\n"
        )

    # Looping reset
    f.write(
        f"\nexecute if score sin darts.main matches {steps} run scoreboard players set sin darts.main -1\n"
    )

print(f"Successfully wrote to {output_file}")