#version 150

#moj_import <mix_light.glsl>
#moj_import <fog.glsl>

uniform sampler2D Sampler0;

uniform vec3 Light0_Direction;
uniform vec3 Light1_Direction;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

uniform mat4 ProjMat;
in float vertexDistance;
in vec4 vertexColor;
in vec4 shadeColor;
in vec4 lightColor;
in vec4 overlayColor;
in vec2 texCoord0;
in vec4 normal;
in vec3 Pos;
in vec3 Light0;
in vec3 Light1;

out vec4 fragColor;

void main() {
    vec3 normal = normalize(cross(dFdx(Pos), dFdy(Pos)));
    vec4 light = mix_light(Light0_Direction, Light1_Direction, normal);
    vec4 color = texture(Sampler0, texCoord0) * ColorModulator;
    if (ProjMat[3][2] == -2.0) color *= shadeColor;
    else color *= light * vertexColor;
    if (color.a < 0.1) discard;
    color.rgb = mix(overlayColor.rgb, color.rgb, overlayColor.a);
    color *= lightColor;
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}