import os
import json

def main():
    base_dir = os.path.abspath(os.path.dirname(__file__))
    folder_name = os.path.basename(base_dir)

    textures_items = os.path.join(base_dir, "textures", "item")
    items_dir = os.path.join(base_dir, "items")
    models_item_dir = os.path.join(base_dir, "models", "item")

    # Ensure output directories exist
    os.makedirs(items_dir, exist_ok=True)
    os.makedirs(models_item_dir, exist_ok=True)

    # Get list of PNG names (without extension)
    png_files = [
        os.path.splitext(f)[0]
        for f in os.listdir(textures_items)
        if f.lower().endswith(".png")
    ]

    for name in png_files:
        # -------------------------
        # Generate items/*.json
        # -------------------------
        item_json_path = os.path.join(items_dir, f"{name}.json")
        if not os.path.exists(item_json_path):
            item_json = {
                "model": {
                    "type": "minecraft:model",
                    "model": f"{folder_name}:item/{name}"
                }
            }

            with open(item_json_path, "w") as f:
                json.dump(item_json, f, indent=4)
            print(f"Created: {item_json_path}")
        else:
            print(f"Skipped (already exists): {item_json_path}")

        # -------------------------
        # Generate models/item/*.json
        # -------------------------
        model_json_path = os.path.join(models_item_dir, f"{name}.json")
        if not os.path.exists(model_json_path):
            model_json = {
                "parent": "item/generated",
                "textures": {
                    "layer0": f"{folder_name}:item/{name}"
                }
            }

            with open(model_json_path, "w") as f:
                json.dump(model_json, f, indent=4)
            print(f"Created: {model_json_path}")
        else:
            print(f"Skipped (already exists): {model_json_path}")

    print("\nDone!")

if __name__ == "__main__":
    main()
