#version 150

uniform sampler2D DiffuseSampler;
uniform sampler2D TextSampler;
uniform sampler2D CameraSampler;
uniform sampler2D BatterySampler;
uniform sampler2D BottomButtonSampler;
uniform sampler2D AuxSampler;
/* 
[R: power -> 0-100, G: usage -> 0-4, B: time -> 1-6]
[R: night -> 1-7, G: camera -> 11, B: inside camera -> T or F]
*/

in vec2 texCoord;

uniform vec2 ScreenSize;
uniform vec2 CharSize;
uniform vec2 CameraMapSize;
uniform vec2 BatteryIconSize;
uniform float Time;

out vec4 fragColor;

#define RED vec4(1,0,0,1)
#define twoPI 6.2831853

float pi = 3.14159265359;
float curvature = 0.065;
float vignetteStrength = 0.4;
float theScanLine = 0.;

//By noClueBruh :]

vec2 curve(vec2 inp)
{
    //curves the screen
    inp.x = inp.x - sin(inp.y * pi) * curvature * (inp.x-0.5);
    inp.y = inp.y - sin(inp.x * pi) * curvature * (inp.y-0.5);
    return inp;
}

vec2 zoomOut(vec2 inp)
{
    //zooms out so that the curved screen fits
    float zoom = 1.+ 1.3*curvature;
    return vec2(.5,.5) + ((inp-vec2(.5,.5))*zoom);
}

#define MAX_STRING_LEN 16

/* 
Size of letter 51x51
Space between rows 15 pixels
*/
vec4 putChar(int charIndex, vec2 screenCoords, float scale, vec2 uv)
{

    bool con1 = uv.x > screenCoords.x && uv.y > screenCoords.y; // Bottom left corner boundary
    bool con2 = uv.x < (screenCoords.x + CharSize.x * scale / ScreenSize.x) && uv.y < (screenCoords.y + CharSize.y * scale / ScreenSize.y); // Top right corner boundary
    if (con1 && con2){
        float offset;
        offset = charIndex;
        offset *= CharSize.x / textureSize(TextSampler, 0).x;
        vec2 SamplerScale = ScreenSize / textureSize(TextSampler, 0) / scale;
        vec2 coords = uv - screenCoords;
        coords *= SamplerScale;
        coords.y = (CharSize.y / textureSize(TextSampler, 0).y) - coords.y; // flips the character so it's displayed correctly
        vec4 tex = texture(TextSampler, coords + vec2(offset, 0.0));
        return tex;
    }
    return vec4(0);
}

vec4 putStr(int str[MAX_STRING_LEN], vec2 screenCoords, float scale, float offset, vec2 uv)
{
    scale = min(ScreenSize.x / 2560.0, ScreenSize.y / 1346.0) * scale;
    offset = min(ScreenSize.x / 2560.0, ScreenSize.y / 1346.0) * offset;

    vec4 tex = vec4(0);
    for (int i = 0; i < MAX_STRING_LEN; i++)
    {
        if (str[i] == -1) {
            screenCoords.x += (CharSize.x * scale + offset) / ScreenSize.x;
            continue;
        }
        tex += putChar(str[i], screenCoords, scale, uv);
        screenCoords.x += (CharSize.x * scale + offset) / ScreenSize.x;
    }
    return tex;
    
}

vec4 putStrLong(int str[MAX_STRING_LEN+4], vec2 screenCoords, float scale, float offset, vec2 uv)
{
    vec4 tex = vec4(0);
    for (int i = 0; i < MAX_STRING_LEN+4; i++)
    {
        if (str[i] == -1) {
            screenCoords.x += (CharSize.x * scale + offset) / ScreenSize.x;
            continue;
        }
        tex += putChar(str[i], screenCoords, scale, uv);
        screenCoords.x += (CharSize.x * scale + offset) / ScreenSize.x;
    }
    return tex;
}

vec4 renderCameraMap(int selectedCamera, vec2 uv) {
    uv.y = 1. - uv.y;

    uv -= vec2(0.6, 0.525);
    uv *= 0.7;
    uv.y *= CameraMapSize.x / CameraMapSize.y;

    vec2 cameraAtlasSize = textureSize(CameraSampler, 0);
    if (uv.x > CameraMapSize.x / cameraAtlasSize.x || uv.y > CameraMapSize.y / cameraAtlasSize.y || uv.x < 0 || uv.y < 0) return vec4(0);
    
    uv.x += CameraMapSize.x / cameraAtlasSize.x * (selectedCamera % 4);
    uv.y += CameraMapSize.y / cameraAtlasSize.y * (selectedCamera / 4);


    return texture(CameraSampler, uv);
}

vec4 renderBatteryIcon(int batteryUsage, vec2 uv) {

    uv.y = 1. - uv.y;

    uv -= vec2(0.13, 0.915);
    uv *= 10;

    vec2 batteryIconAtlasSize = textureSize(BatterySampler, 0);
    if (uv.x > BatteryIconSize.x / batteryIconAtlasSize.x || uv.y > BatteryIconSize.y / batteryIconAtlasSize.y || uv.x < 0 || uv.y < 0) return vec4(0);

    uv.x += BatteryIconSize.x / batteryIconAtlasSize.x * (batteryUsage / 2);
    uv.y += BatteryIconSize.y / batteryIconAtlasSize.y * (batteryUsage % 2);

    return texture(BatterySampler, uv);
}

vec4 renderButton(vec2 uv) {
    uv.y = 1. - uv.y;
    uv -= vec2(0.25,0.9);
    uv *= 2.6;


    vec2 atlasSize = textureSize(BottomButtonSampler, 0);
    uv.y *= atlasSize.x / atlasSize.y;

    if (uv.x > 1.0 || uv.y > 1.0 || uv.x < 0.0 || uv.y < 0.0) return vec4(0);


    return texture(BottomButtonSampler, uv);
}

vec4 renderAreaText(int selectedCamera, vec2 uv) {
    // Kitchen
    switch (selectedCamera) {
        case 0:  // Show Stage
            return putStr(int[](30,45,52,60,-1,30,57,38,44,42,-1,-1,-1,-1,-1,-1), vec2(0.625, 0.46), 0.75, 6, uv);
        case 1: // Dining Area
            return putStr(int[](15,46,51,46,51,44,-1,12,55,42,38,-1,-1,-1,-1,-1), vec2(0.625, 0.46), 0.75, 6, uv);
        case 2: // Pirate Cove
            return putStr(int[](27,46,55,38,57,42,-1,14,52,59,42,-1,-1,-1,-1,-1), vec2(0.625, 0.46), 0.75, 6, uv);
        case 3: // West Hall
            return putStr(int[](34,42,56,57,-1,19,38,49,49,-1,-1,-1,-1,-1,-1,-1), vec2(0.625, 0.46), 0.75, 6, uv);
        case 4: // W. Hall Corner
            return putStr(int[](34,64,19,38,49,49,-1,14,52,55,51,42,55,-1,-1,-1), vec2(0.625, 0.46), 0.75, 6, uv);
        case 5: // Supply Closet
            return putStr(int[](30,58,53,53,49,62,-1,14,49,52,56,42,57,-1,-1,-1), vec2(0.625, 0.46), 0.75, 6, uv);
        case 6: // East Hall
            return putStr(int[](16,38,56,57,-1,19,38,49,49,-1,-1,-1,-1,-1,-1,-1), vec2(0.625, 0.46), 0.75, 6, uv);
        case 7: // E. Hall Corner
            return putStr(int[](16,64,19,38,49,49,-1,14,52,55,51,42,55,-1,-1,-1), vec2(0.625, 0.46), 0.75, 6, uv);
        case 8: // Backstage
            return putStr(int[](13,38,40,48,56,57,38,44,42,-1,-1,-1,-1,-1,-1,-1), vec2(0.625, 0.46), 0.75, 6, uv);
        case 9: // Kitchen
            return putStr(int[](22,46,57,40,45,42,51,-1,-1,-1,-1,-1,-1,-1,-1,-1), vec2(0.625, 0.46), 0.75, 6, uv);
        case 10: // Restrooms
            return putStr(int[](29,42,56,57,55,52,52,50,56,-1,-1,-1,-1,-1,-1,-1), vec2(0.625, 0.46), 0.75, 6, uv);
    }

    return vec4(0);
}


void main() 
{
    float time = Time * twoPI;

    // Check if youre inside a camera or not and curve the screen depending on that

    // Is the player inside a camera?
    bool insideCamera = texelFetch(AuxSampler, ivec2(1,0), 0).b > 0.5;

    vec2 uv = texCoord;

    if (insideCamera) {
        uv = zoomOut(curve(texCoord));
    }

    // Power left:
    vec4 powerLeftText = putStr(int[](27,52,60,42,55,-1,49,42,43,57,11,-1,-1,-1,-1,-1), vec2(0.05, 0.1), 0.5, 6, uv);

    // Percentage of power
    int[] percentageArr = int[](-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,4,0,-1);
    int powerPercentage = int(texelFetch(AuxSampler, ivec2(0), 0).r * 255.0);
    percentageArr[12] = powerPercentage / 10 + 1;
    percentageArr[13] = powerPercentage % 10 + 1;

    if (percentageArr[12] == 1) percentageArr[12] = -1;
    if (percentageArr[13] == 1) percentageArr[13] = 65;

    if (powerPercentage == 0) {
        percentageArr[12] = -1;
        percentageArr[13] = 65;
    }

    vec4 powerPercentageText = putStr(percentageArr, vec2(0, 0.1), 0.7, 6, uv);

    // Usage:
    vec4 usageText = putStr(int[](32,56,38,44,42,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1), vec2(0.05, 0.05), 0.5, 6, uv);
    int batteryUsage = int(texelFetch(AuxSampler, ivec2(0), 0).g * 255.0);

    // x AM
    int[] amArr = int[](3,-1,12,24,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1);
    int hour = int(texelFetch(AuxSampler, ivec2(0,0), 0).b * 255.0);
    amArr[0] = hour + 1;
    vec4 AMText = putStr(amArr, vec2(0.88, 0.91), 0.9, 6, uv);
    if (hour == 0) {
        AMText = putStr(int[](2,3,-1,12,24,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1), vec2(0.855, 0.91), 0.9, 6, uv);
    }
    

    // Night x
    int[] nightArr = int[](25,46,44,45,57,-1,3,-1,-1,-1,-1,-1,-1,-1,-1,-1);
    int night = int(texelFetch(AuxSampler, ivec2(1,0), 0).r * 255.0);
    if (night == 0) night = 64;
    nightArr[6] = night + 1;
    vec4 nightText = putStr(nightArr, vec2(0.87, 0.87), 0.5, 6, uv);

    vec4 areaText = vec4(0);

    // Area text
    int selectedCamera = int(texelFetch(AuxSampler, ivec2(1,0), 0).g * 255.0);
    if (insideCamera)
        areaText = renderAreaText(selectedCamera, uv);

    // All text combined
    vec4 compositeText = powerLeftText + usageText + AMText + nightText + areaText + powerPercentageText;

    // Only display the camera map in camera mode
    // Camera icon
    vec4 cameraIcon = vec4(0);

    if (insideCamera)
        cameraIcon = renderCameraMap(selectedCamera, uv);

    vec4 batteryIcon = renderBatteryIcon(batteryUsage, uv);

    vec4 disabledCameraText1 = vec4(0);
    vec4 disabledCameraText2 = vec4(0);

    // Disabled Camera 6 has some extra text in the centre of the screen
    if (selectedCamera == 9 && insideCamera) {
        disabledCameraText1 = putStrLong(int[](1,14,12,24,16,29,12,-1,15,20,30,12,13,23,16,15,1,-1,-1,-1), vec2(0.375, 0.825), 0.7, 6, uv);
        disabledCameraText2 = putStr(int[](12,32,15,20,26,-1,26,25,23,36,-1,-1,-1,-1,-1,-1), vec2(0.43, 0.795), 0.7, 6, uv);
    }

    vec4 bottomButton = renderButton(uv);
    
    fragColor = mix(vec4(0.0), compositeText, compositeText.a); // by mixing it you can overlay stuff
    fragColor = mix(fragColor, disabledCameraText1, disabledCameraText1.a);
    fragColor = mix(fragColor, disabledCameraText2, disabledCameraText2.a);
    fragColor = mix(fragColor, cameraIcon, cameraIcon.a);
    fragColor = mix(fragColor, batteryIcon, batteryIcon.a);
    fragColor = mix(fragColor, bottomButton, bottomButton.a);

    if (gl_FragCoord.x < 3.5 && gl_FragCoord.y < 3.5){
        fragColor = vec4(0,0,0,1);
    }
}