#version 150

uniform sampler2D DiffuseSampler;
uniform sampler2D AuxSampler;
/* 
[R: power -> 0-100, G: usage -> 0-4, B: time -> 1-6]
[R: night -> 1-7, G: camera -> 11, B: inside camera -> T or F]
[R: enable overlay -> T or F]
*/

in vec2 texCoord;

uniform vec2 ScreenSize;

out vec4 fragColor;

void writePixel(vec4 pixel, vec2 coords) {
    vec2 auxSize = textureSize(AuxSampler, 0);
    if (gl_FragCoord.x >= coords.x && gl_FragCoord.x < coords.x+1 && gl_FragCoord.y >= coords.y && gl_FragCoord.y < coords.y+1) {
        fragColor = pixel;
    }
}

void main() {
    vec4 markerPixel = texelFetch(DiffuseSampler, ivec2(0,0), 0);

    fragColor = texture(AuxSampler, texCoord);

    if (markerPixel.r > 0.95) { // The marker pixel is actually activated
        // markerPixel.g * 255 == 1 -> power
        // markerPixel.g * 255 == 2 -> usage
        // markerPixel.g * 255 == 3 -> time
        // markerPixel.g * 255 == 4 -> night
        // markerPixel.g * 255 == 5 -> camera

        vec4 pixel;
        switch(int(markerPixel.g * 255.0)) {
            case 1: // Power
                pixel = texelFetch(AuxSampler, ivec2(0), 0);
                pixel.r = markerPixel.b;
                writePixel(pixel, vec2(0,0));
                break;
            case 2: // Usage
                pixel = texelFetch(AuxSampler, ivec2(0), 0);
                pixel.g = markerPixel.b;
                writePixel(pixel, vec2(0,0));
                break;
            case 3: // Time
                pixel = texelFetch(AuxSampler, ivec2(0), 0);
                pixel.b = markerPixel.b;
                writePixel(pixel, vec2(0,0));
                break;
            case 4: // Night
                pixel = texelFetch(AuxSampler, ivec2(1,0), 0);
                pixel.r = markerPixel.b;
                writePixel(pixel, vec2(1,0));
                break;
            case 5: // Camera
                pixel = texelFetch(AuxSampler, ivec2(1,0), 0);
                pixel.g = markerPixel.b;
                writePixel(pixel, vec2(1,0));
                break;
            case 127: // Inside of a camera effect: above 127 then inside camera otherwise normal view
                pixel = texelFetch(AuxSampler, ivec2(1,0), 0);
                pixel.b = markerPixel.b;
                writePixel(pixel, vec2(1,0));
                break;
            case 128: // Enable overlay
                pixel = texelFetch(AuxSampler, ivec2(2,0), 0);
                pixel.r = 1.0;
                writePixel(pixel, vec2(2,0));
                break;
            case 129: // Disalbe overlay
                pixel = texelFetch(AuxSampler, ivec2(2,0), 0);
                pixel.r = 0.0;
                writePixel(pixel, vec2(2,0));
                break;
        }
        
    }

    fragColor.a = 1.0;
}