#version 150

uniform sampler2D DiffuseSampler;
uniform sampler2D OverlaySampler;
uniform sampler2D AuxSampler;


in vec2 texCoord;

out vec4 fragColor;

void main() {
    float enableOverlay = texelFetch(AuxSampler, ivec2(2,0), 0).r;

    if (enableOverlay > 0.5) {
        vec4 overlay = texture(OverlaySampler, texCoord);
        fragColor = mix(texture(DiffuseSampler, texCoord), overlay, overlay.a);
    } else {
        fragColor = texture(DiffuseSampler, texCoord);
    }
}