#version 150

#moj_import <fog.glsl>

in vec3 Position;
in vec4 Color;
in vec2 UV0;
in ivec2 UV2;

uniform sampler2D Sampler2;
uniform sampler2D Sampler0;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;
uniform mat3 IViewRotMat;
uniform int FogShape;
uniform vec2 ScreenSize;

out float vertexDistance;
out vec4 vertexColor;
out vec2 texCoord0;

flat out vec2 flatUv;

out vec2 nScreenCoord;

out vec2 angle;

#define PI 3.1415926535897932384626433832795


// Convert a 3d rotation matrix to a 2d rotation vector
vec2 getangle(mat3 m) {
    float y = atan(m[0][0]-1.0, m[2][0]);
    float x = atan(-m[1][2], m[1][1]);
    return vec2(-y, x) / PI;
}

void main() {
    gl_Position = ProjMat * ModelViewMat * vec4(Position, 1.0);

    mat3 cameraRotationMat = transpose(IViewRotMat);


    angle = getangle(cameraRotationMat);

    vec4 tex = texture(Sampler0, UV0);
    if (tex.rgb == vec3(1,0,0) || tex.rgb == vec3(0,1,0) || tex.rgb == vec3(0,0,1) || tex.rgb == vec3(1,1,0)) {
        vec2[] corners = vec2[](
          vec2(-1.0, 1.0),
          vec2(-1.0,-1.0),
          vec2( 1.0,-1.0),
          vec2( 1.0, 1.0)
        );

        gl_Position = vec4(corners[gl_VertexID % 4], 0.0, 1.0);
    }

    nScreenCoord = gl_Position.xy / gl_Position.w;
    nScreenCoord.x *= ScreenSize.x / ScreenSize.y;

    vertexDistance = fog_distance(ModelViewMat, IViewRotMat * Position, FogShape);
    vertexColor = Color * texelFetch(Sampler2, UV2 / 16, 0);
    texCoord0 = UV0;

    flatUv = UV0;
    

    // NoShadow behavior (https://github.com/PuckiSilver/NoShadow)
    if (Color.xyz == vec3(78/255., 92/255., 36/255.) && (Position.z == 0.03 || Position.z == 0.06 || Position.z == 0.12)) {
        vertexColor.rgb = texelFetch(Sampler2, UV2 / 16, 0).rgb; // remove color from no shadow marker
    } else if (Color.xyz == vec3(19/255., 23/255., 9/255.) && Position.z == 0) {
        gl_Position = vec4(2,2,2,1); // move shadow off screen
    }

    if (tex.rgb == vec3(1,0,1)) {
        vec2[] cams = vec2[](
          vec2(0.2, -0.05),
          vec2(0.175,-0.97),
          vec2(0.875,-0.95),
          vec2(0.9, -0.05)
        );
        gl_Position = vec4(cams[gl_VertexID % 4], 0.0, 1.0);
    }
}
