#version 150

#moj_import <fog.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;
uniform vec2 ScreenSize;
uniform float GameTime;

in float vertexDistance;
in vec4 vertexColor;
in vec2 texCoord0;

flat in vec2 flatUv;

in vec2 angle;
in vec2 nScreenCoord;

out vec4 fragColor;

#define time GameTime*100000

float degToRad(float deg) {
    return deg * 3.1415926535897932384626433832795 / 180.0;
}

float radToDeg(float rad) {
    return rad * 180.0 / 3.1415926535897932384626433832795;
}

bool rougheq(float a, float b, float epsilon) {
    return abs(a - b) < epsilon;
}

vec2 wrap(vec2 p) {
    return mod(p + 1.0, 2.0) - 1.0;
}

float pi = 3.14159265359;
float curvature = 0.065;
float vignetteStrength = 0.4;
float theScanLine = 0.;

vec2 curve(vec2 inp)
{
    //curves the screen
    inp.x = inp.x - sin(inp.y * pi) * curvature * (inp.x-0.5);
    inp.y = inp.y - sin(inp.x * pi) * curvature * (inp.y-0.5);
    return inp;
}

vec2 zoomOut(vec2 inp)
{
    //zooms out so that the curved screen fits
    float zoom = 1.+ 1.3*curvature;
    return vec2(.5,.5) + ((inp-vec2(.5,.5))*zoom);
}

bool inRect(vec2 rect, vec2 rectDim, vec2 inp)
{
    //method that detects if a point is inside a rectangle
    return clamp(inp, rect, rectDim) == inp;
}

float rand(float n)
{
    //random number generator
    return fract(sin(n) * 43758.5453123);
}

int randInt(float n) {
    return int(rand(n) * 1000000);
}

vec4 staticc(vec2 inp)
{
    
    float t = 0.;
    //little scanlines
    t = cos(inp.y * ScreenSize.y) * 2.;
    
    //the static
    t += tan(sin(100. + time * cos(100. + time) * 2.)*14. * inp.y) * 0.05;
    return vec4(t,t,t,1);
}

float lerp(float a, float b, float c)
{
    //lerp
    return a + c*(b-a);
}

vec4 vignette(vec2 inp)
{
    //cheap vignette effect 
    float t = 0.;
    t = lerp(0.5, vignetteStrength * distance(inp, vec2(0.5,0.5)),0.98);
    return vec4(t,t,t,1);
}

const float e = 2.7182818284590452353602874713527;

vec4 noise(vec2 texCoord)
{
    float G = e + (GameTime * 0.1);
    vec2 r = (G * sin(G * texCoord.xy));
    return vec4(fract(r.x * r.y * (1.0 + texCoord.x)));
}

void main() {
    vec4 tex = texture(Sampler0, texCoord0);
    vec4 color = tex * vertexColor * ColorModulator;
    if (color.a < 0.1) {
        discard;
    }
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);

    if (tex.rgb == vec3(1,0,0)) { // Cursor

        vec2 ratio = vec2(ScreenSize.x / ScreenSize.y, 1.0);
        vec2 coord = nScreenCoord * 0.2 + vec2(0.5, 0);
        vec2 cursor_pos = angle;

        float dist = length(coord - cursor_pos);

        if (dist > 0.0019 && dist < 0.0025) {
            fragColor = vec4(0.7);
        } else {
            discard;
        }
    } else if (tex.rgb == vec3(0,1,0)) { // Camera static 
        vec2 uv = zoomOut(curve(gl_FragCoord.xy / ScreenSize.xy));
        vec4 col; 

        //big scanline
        theScanLine = sin(time*pi+uv.y)+tan(time - uv.y*uv.y)-cos(uv.y);

        //borderCheck
        if(inRect(vec2(0,0),vec2(1.,1.),uv))
        {
            //big scanline stuff 
            if(inRect(vec2(0,theScanLine),vec2(1,theScanLine + 0.1),uv))
                uv.x -= sin(theScanLine-uv.y) * 0.15;

            col = vec4(1);
            col -= vignette(uv);
            col += staticc(uv) * 0.015 * 1.5;

            vec2 coords = gl_FragCoord.xy;

            const float f = 4.0;
            coords.x = floor(coords.x / f) * f;

            col += noise(coords) * 0.1;
            col.a -= 0.035;
        }
        else
            col = vec4(0,0,0,1);

        fragColor = col;

        // Camera outline around screen
        vec2 curvedUv = zoomOut(curve(gl_FragCoord.xy / ScreenSize.xy));
        float lineWidth = 1.75 / ScreenSize.x;
        const float lineDist = 0.015;
        const vec4 lineColor = vec4(0.8);

        if (abs(curvedUv.x - lineDist) < lineWidth && (curvedUv.y > lineDist && curvedUv.y < (1 - lineDist))) fragColor = lineColor;
        else if (abs(curvedUv.x - (1 - lineDist)) < lineWidth && (curvedUv.y > lineDist && curvedUv.y < (1 - lineDist))) fragColor = lineColor;
        else if (abs(curvedUv.y - (1 - lineDist)) < lineWidth && (curvedUv.x > lineDist && curvedUv.x < (1 - lineDist))) fragColor = lineColor;
        else if (abs(curvedUv.y - lineDist) < lineWidth && (curvedUv.x > lineDist && curvedUv.x < (1 - lineDist))) fragColor = lineColor;
        
        curvedUv.y *= 0.75;
        curvedUv.y += 0.25;

        // Red dot in top left of screen
        if (distance(curvedUv, vec2(0.07, 0.935)) < 0.0125) fragColor += round(sin(GameTime * 2500) * 0.5 + 0.5) * vec4(0.5,-1,-1,0.75);

    } else if (tex.rgb == vec3(0,0,1)) {
        vec2 uv = gl_FragCoord.xy / ScreenSize.xy;
        vec4 col = vec4(0,0,0,1); 

        //big scanline
        theScanLine = sin(time*pi+uv.y)+tan(time - uv.y*uv.y)-cos(uv.y);

        if(inRect(vec2(0,theScanLine),vec2(1,theScanLine + 0.1),uv))
                uv.x -= sin(theScanLine-uv.y) * 0.15;

        col = vec4(1);
        col -= vignette(uv);
        col += staticc(uv) * 0.050 * 1.5;
        vec2 coords = gl_FragCoord.xy;
        const float f = 4.0;
        coords.x = floor(coords.x / f) * f;
        col += noise(coords) * 0.125;
        col.a -= 0.035;
        col.rgb *= col.a;

        fragColor = col * 0.4;

        fragColor.a = 1.0;

    } else if (tex.rgb == vec3(1,1,0)) {
        // randomly select between 1 and 5 random y coordinates on the screen
        // and draw a line from the left to the right of the screen at that y coordinate

        float[] yCoordinates = float[](5, 5, 5, 5, 5);

        int amountOfLines = randInt(GameTime * 1000) % 3;

        for (int i = 0; i < amountOfLines; i++) {
            // yCoordinates is in range [-1, 1]
            yCoordinates[i] = mod(rand(GameTime * 1000.0 + i), 1);
        }

        vec4 col = vec4(0,0,0,0);

        vec2 uv = zoomOut(curve(gl_FragCoord.xy / ScreenSize.xy));

        if(inRect(vec2(0,0),vec2(1.,1.),uv))
        {
            for (int i = 0; i < amountOfLines; i++) {
                if (abs(uv.y - yCoordinates[i]) < 0.06) {
                    col = vec4(1);
                    break;
                }
            }
        }
        else
            col = vec4(0,0,0,1);

        fragColor = col;
    }
    if (tex.rgb == vec3(1,0,1)) discard;
}
