#version 150

in vec3 Position;
in vec4 Color;
in vec2 UV0;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;
uniform mat3 IViewRotMat;

uniform vec4 FogColor;

out vec4 vertexColor;
out vec2 texCoord0;

mat3 rotY3(float angle) {
    return mat3(
        cos(angle), 0.0, sin(angle),
        0.0, 1.0, 0.0,
        -sin(angle), 0.0, cos(angle)
    );
}

bool rougheq(vec2 a, vec2 b, float epsilon) {
    return abs(a.x - b.x) < epsilon && abs(a.y - b.y) < epsilon;
}

void main() {

    mat3 rotationMatrix = mat3(
        1.0, 0.0, 0.0,
        0.0, 1.0, 0.0,
        0.0, 0.0, 1.0
    );

    mat4 proj = ProjMat;

    // Detect if special biome is used for the rotation of the camera
    if (rougheq(FogColor.rg * 255.0, vec2(0.0, 0.0), 1.0)) {

        float b = round(FogColor.b * 255.0 / 5.0);
        
        float angle = b * 2.25;
        if (angle > 45) angle = -(angle - 45);

        rotationMatrix = rotY3(radians(angle + 180)) * IViewRotMat;

        float origTanFovHalf = 1.0 / proj[1][1];
        float newTanFovHalf = tan(radians(70.0) / 2);
        float correctionRatio = origTanFovHalf / newTanFovHalf;
        proj[0][0] *= correctionRatio;
        proj[1][1] *= correctionRatio;
    }

    gl_Position = proj * ModelViewMat * vec4(rotationMatrix * Position, 1.0);

    vertexColor = Color;
    texCoord0 = UV0;
}
