#version 150

#moj_import <light.glsl>
#moj_import <fog.glsl>

in vec3 Position;
in vec4 Color;
in vec2 UV0;
in ivec2 UV2;
in vec3 Normal;

uniform sampler2D Sampler0;
uniform sampler2D Sampler2;

uniform float FogStart;
uniform int FogShape;
uniform mat4 ModelViewMat;
uniform mat4 ProjMat;
uniform mat3 IViewRotMat;
uniform float GameTime;

uniform vec4 FogColor;

uniform vec3 Light0_Direction;
uniform vec3 Light1_Direction;

out float vertexDistance;
out vec4 vertexColor;
out vec4 lightColor;
out vec4 overlayColor;
out vec2 texCoord;
out vec2 texCoord2;
out vec3 Pos;
out float transition;

flat out int isCustom;
flat out int isGUI;
flat out int isHand;
flat out int noshadow;

flat out float isMarker;
out vec4 leatherColor;

flat out float isCamera;

out vec2 lightLevel;

#moj_import <objmc_tools.glsl>

mat3 rotY3(float angle) {
    return mat3(
        cos(angle), 0.0, sin(angle),
        0.0, 1.0, 0.0,
        -sin(angle), 0.0, cos(angle)
    );
}

mat3 rotX3(float angle) {
    return mat3(
        1.0, 0.0, 0.0,
        0.0, cos(angle), -sin(angle),
        0.0, sin(angle), cos(angle)
    );
}

bool rougheq(vec2 a, vec2 b, float epsilon) {
    return abs(a.x - b.x) < epsilon && abs(a.y - b.y) < epsilon;
}

bool rougheq(float a, float b, float epsilon) {
    return abs(a - b) < epsilon;
}


void main() {
    isCamera = 0.0;

    Pos = Position;
    texCoord = UV0;
    overlayColor = vec4(1);
    leatherColor = Color;
    lightColor = minecraft_sample_lightmap(Sampler2, UV2);
    vertexColor = minecraft_mix_light(Light0_Direction, Light1_Direction, Normal, Color);

    //objmc
    #define ENTITY
    #moj_import <objmc_main.glsl>

    // identity matrix
    mat3 rotationMatrix = mat3(
        1.0, 0.0, 0.0,
        0.0, 1.0, 0.0,
        0.0, 0.0, 1.0
    );

    mat4 proj = ProjMat;

    // Detect if special biome is used for the rotation of the camera in the office
    if (rougheq(FogColor.rg * 255.0, vec2(0.0, 0.0), 1.0)) {

        float b = round(FogColor.b * 255.0 / 5.0);

        if (rougheq(FogColor.b * 255.0,105.0,1.0)) {
            b = 100.0;
        }
        
        float angle = b * 2.25;
        if (angle > 45.0) angle = -(angle - 45.0);

        rotationMatrix = rotY3(radians(angle + 180.0)) * IViewRotMat;

        float origTanFovHalf = 1.0 / proj[1][1];
        float newTanFovHalf = tan(radians(70.0) / 2.0);
        float correctionRatio = origTanFovHalf / newTanFovHalf;
        proj[0][0] *= correctionRatio;
        proj[1][1] *= correctionRatio;
    }


    // Detect if special biome is used for the actual video cameras CAM
    if (rougheq(FogColor.r, FogColor.g, 10.0 / 255.0) && FogColor.r > 0.75) {
        float FOV = 70.0;
        float yaw = 0.0;
        float pitch = 0.0;

        #moj_import "rotation.glsl"

        float timeOffset = clamp(sin(GameTime * 125.0) * 40, -15, 15);

        rotationMatrix = rotX3(radians(-pitch)) * rotY3(radians(-yaw + 180 + timeOffset)) * IViewRotMat;


        float origTanFovHalf = 1.0 / proj[1][1];
        float newTanFovHalf = tan(radians(FOV) / 2);
        float correctionRatio = origTanFovHalf / newTanFovHalf;
        proj[0][0] *= correctionRatio;
        proj[1][1] *= correctionRatio;

        isCamera = 1.0;
    }

    vec4 color = texture(Sampler0,UV0);
    isMarker = 0.0;

    if (color == vec4(1,0,0,1)){
        isMarker = 1.0;
    }
    vec4 tmp = proj * ModelViewMat * vec4(rotationMatrix * Pos, 1.0);
    if (isMarker > 0.0){
        if (gl_VertexID % 4 == 0){
            tmp = vec4(-1,-0.9,-1,1);
        }else if(gl_VertexID % 4 == 1){
            tmp = vec4(-1,-1,-1,1);
        }else if(gl_VertexID % 4 == 2){
            tmp = vec4(-0.9,-1,-1,1);
        }else if(gl_VertexID % 4 == 3){
            tmp = vec4(-0.9,-0.9,-1,1);
        }
    }
    
    gl_Position = tmp;
    
    vertexDistance = fog_distance(ModelViewMat, rotationMatrix * Pos, FogShape);
    vec3 normal = (proj * ModelViewMat * vec4(rotationMatrix * Normal, 0.0)).rgb;
}