#version 150

#moj_import <light.glsl>
#moj_import <fog.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

uniform vec3 Light0_Direction;
uniform vec3 Light1_Direction;

in float vertexDistance;
in vec4 vertexColor;
in vec4 lightColor;
in vec4 overlayColor;
in vec2 texCoord;
in vec2 texCoord2;
in vec3 Pos;
in float transition;

flat in int isCustom;
flat in int isGUI;
flat in int isHand;
flat in int noshadow;

flat in float isMarker;
in vec4 leatherColor;

in vec2 lightLevel;
flat in float isCamera;

out vec4 fragColor;

#define RED vec4(1,0,0,1)

#moj_import <tonemap.glsl>

bool rougheq(float a, float b, float eps) {
    return abs(a - b) < eps;
}

void main() {
    vec4 color = mix(texture(Sampler0, texCoord), texture(Sampler0, texCoord2), transition);

    //custom lighting
    #define ENTITY
    #moj_import<objmc_light.glsl>

    if (color.a < 0.01) discard;
    
    // fragColor = linear_fog(color, vertexDistance, -300, FogEnd, vec4(0,0,0,1));
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);

    if (rougheq(color.a, 128.0/255.0, 0.5 / 255.0)) {
        fragColor = vec4(1);
    }

    if (isCamera > 0.5) {
        fragColor.rgb = tonemap(fragColor.rgb);
    } else {
        fragColor.rgb = aces(fragColor.rgb);
    }

    if (isMarker > 0.5){
        if (gl_FragCoord.x < 3.5 && gl_FragCoord.y < 3.5){
            fragColor = leatherColor;
        } else {
            discard;
        }
    }
}