#version 150

#moj_import <light.glsl>
#moj_import <fog.glsl>

in vec3 Position;
in vec4 Color;
in vec2 UV0;
in ivec2 UV2;
in vec3 Normal;

uniform sampler2D Sampler0;
uniform sampler2D Sampler2;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;
uniform vec3 ChunkOffset;
uniform int FogShape;
uniform float GameTime;

uniform vec4 FogColor;

out float vertexDistance;
out vec4 vertexColor;
out vec4 lightColor;
out vec2 texCoord;
out vec2 texCoord2;
out vec3 Pos;
out float transition;
flat out float isCamera;

flat out int isCustom;
flat out int noshadow;

#moj_import <objmc_tools.glsl>

// rotate camera around the y axis
mat4 rotY(float angle) {
    return mat4(
        cos(angle), 0.0, sin(angle), 0.0,
        0.0, 1.0, 0.0, 0.0,
        -sin(angle), 0.0, cos(angle), 0.0,
        0.0, 0.0, 0.0, 1.0
    );
}

mat3 rotY3(float angle) {
    return mat3(
        cos(angle), 0.0, sin(angle),
        0.0, 1.0, 0.0,
        -sin(angle), 0.0, cos(angle)
    );
}

mat4 rotX(float angle) {
    return mat4(
        1.0, 0.0, 0.0, 0.0,
        0.0, cos(angle), -sin(angle), 0.0,
        0.0, sin(angle), cos(angle), 0.0,
        0.0, 0.0, 0.0, 1.0
    );
}

bool rougheq(vec2 a, vec2 b, float epsilon) {
    return abs(a.x - b.x) < epsilon && abs(a.y - b.y) < epsilon;
}

bool rougheq(float a, float b, float epsilon) {
    return abs(a - b) < epsilon;
}


void main() {
    isCamera = 0.0;
    //default
    Pos = Position + ChunkOffset;

    texCoord = UV0;
    vertexColor = Color;
    lightColor = minecraft_sample_lightmap(Sampler2, UV2);

    //objmc
    #define BLOCK
    #moj_import <objmc_main.glsl>

    mat4 rotationMatrix = ModelViewMat;

    mat4 proj = ProjMat;

    // Detect if special biome is used for the rotation of the camera
    if (rougheq(FogColor.rg * 255.0, vec2(0.0, 0.0), 1.0)) {

        float b = round(FogColor.b * 255.0 / 5.0);

        if (rougheq(FogColor.b * 255.0,115.0,1.0) || rougheq(FogColor.b * 255.0, 105.0, 1.0)) {
            b = 100.0;
        }
        
        float angle = b * 2.25;
        if (angle > 45.0) angle = -(angle - 45.0);

        rotationMatrix = rotY(radians(angle+180.0));

        float origTanFovHalf = 1.0 / proj[1][1];
        float newTanFovHalf = tan(radians(70.0) / 2.0);

        float correctionRatio = origTanFovHalf / newTanFovHalf;
        proj[0][0] *= correctionRatio;
        proj[1][1] *= correctionRatio;
    }

    // Detect if special biome is used for the actual video cameras CAM
    if (rougheq(FogColor.r, FogColor.g, 10.0 / 255.0) && FogColor.r > 0.75) {
        float FOV = 70.0;
        float yaw = 0.0;
        float pitch = 0.0;

        #moj_import "rotation.glsl"

        float timeOffset = clamp(sin(GameTime * 125.0) * 40, -15, 15);

        rotationMatrix = rotX(radians(-pitch)) * rotY(radians(-yaw + 180 + timeOffset));


        float origTanFovHalf = 1.0 / proj[1][1];
        float newTanFovHalf = tan(radians(FOV) / 2);
        float correctionRatio = origTanFovHalf / newTanFovHalf;
        proj[0][0] *= correctionRatio;
        proj[1][1] *= correctionRatio;

        isCamera = 1.0;
    }

    gl_Position = proj * rotationMatrix * vec4(Pos, 1.0);
    vertexDistance = fog_distance(rotationMatrix, Pos, FogShape);
    vec3 normal = (proj * rotationMatrix * vec4(Normal, 0.0)).rgb;
}