#version 150

#moj_import <light.glsl>
#moj_import <fog.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec4 vertexColor;
in vec4 lightColor;
in vec2 texCoord;
in vec2 texCoord2;
in vec3 Pos;
in float transition;
flat in float isCamera;

flat in int isCustom;
flat in int noshadow;

out vec4 fragColor;

#define RED vec4(1,0,0,1)

#moj_import <tonemap.glsl>

void main() {
    vec4 color = mix(texture(Sampler0, texCoord), texture(Sampler0, texCoord2), transition);

    //custom lighting
    #define BLOCK
    #moj_import<objmc_light.glsl>

    if (color.a < 0.01) discard;
    // fragColor = linear_fog(color, vertexDistance, -300, FogEnd, vec4(0,0,0,1))/f;
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);


    if (isCamera > 0.5) {
        fragColor.rgb = tonemap(fragColor.rgb);
    } else {
        fragColor.rgb = aces(fragColor.rgb);
    }
}