#version 150
#moj_import <minecraft:fog.glsl>
#moj_import <minecraft:dynamictransforms.glsl>
#moj_import <minecraft:projection.glsl>
#moj_import <minecraft:globals.glsl>

in vec3 Position;
in vec4 Color;
in vec2 UV0;
in ivec2 UV2;

uniform sampler2D Sampler2;

out float sphericalVertexDistance;
out float cylindricalVertexDistance;
out vec4 vertexColor;
out vec2 texCoord0;

vec3 mov(float x) {
    x = -(((x * 2) - 1)) * 6;
    return vec3(0, pow(x, 3), 0);
}

void main() {
    vec3 offset = vec3(0);
    vec3 finalPos = Position; // default
    ivec3 Ucolor = ivec3(Color.rgb * 255);

    if (Ucolor == ivec3(18, 57, 135)) {
        // 123987 → original behavior (white + falling motion)
        vertexColor = vec4(1.0);
        offset += mov(Color.a);

    } else if (Ucolor == ivec3(18, 57, 136)) {
        // 123988 → new behavior (white + scale animation)
        vertexColor = vec4(1.0);

        // use alpha (0..1) as progress: 0=start, 1=end
        float animTime = clamp(Color.a / 0.5, 0.0, 1.0);
        float scale = mix(1.0, 1.5, smoothstep(0.0, 1.0, animTime));

        // scale around glyph origin instead of moving it down
        finalPos.xy = Position.xy * scale;
        finalPos.z = Position.z;

    } else if (Ucolor == ivec3(4, 14, 33)) {
        vertexColor = vec4(62. / 255., 62. / 255., 62. / 255., 0.0);
        offset += mov(Color.a);

    } else {
        vertexColor = Color * texelFetch(Sampler2, UV2 / 16, 0);
    }

    // Apply position
    gl_Position = ProjMat * ModelViewMat * vec4(finalPos + offset, 1.0);

    sphericalVertexDistance = fog_spherical_distance(Position);
    cylindricalVertexDistance = fog_cylindrical_distance(Position);
    texCoord0 = UV0;

    // Shadow behavior removed (so no text shadows at all)
}
